/*
 * Decompiled with CFR 0.152.
 */
package com.jlgm.chatbox.network;

import com.google.common.base.Charsets;
import com.jlgm.chatbox.tileentity.TileEntityChatBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChatBoxMessage
implements IMessage {
    private String chatMessage;
    private int radius;
    private BlockPos pos;
    private World worldObj;

    public ChatBoxMessage() {
    }

    public ChatBoxMessage(String chatMessage, int radius, BlockPos pos) {
        this.chatMessage = chatMessage;
        this.radius = radius;
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.radius);
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.chatMessage.getBytes().length);
        buf.writeBytes(this.chatMessage.getBytes(Charsets.UTF_8));
    }

    public void fromBytes(ByteBuf buf) {
        this.radius = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.chatMessage = buf.readBytes(buf.readInt()).toString(Charsets.UTF_8);
    }

    public static class ChatBoxMessageHandler
    implements IMessageHandler<ChatBoxMessage, IMessage> {
        public IMessage onMessage(ChatBoxMessage message, MessageContext ctx) {
            TileEntity tile = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.pos);
            if (tile instanceof TileEntityChatBox) {
                TileEntityChatBox chatBox = (TileEntityChatBox)tile;
                chatBox.setMessage(message.chatMessage);
                chatBox.setRadius(message.radius);
            }
            return null;
        }
    }
}

