/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidfog;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="voidfog")
public class VoidFog {
    static boolean active;
    static final float[] colors;
    static float color;
    static float fog;
    public static final ResourceKey<Level> WORLD_KEY_VOID;

    public VoidFog() {
        IEventBus busForge = MinecraftForge.EVENT_BUS;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        Config.INSTANCE = (Config)specPair.getLeft();
        busForge.addListener(event -> {
            if (active || fog < 1.0f) {
                float f = 3.0f;
                float f2 = f = f >= event.getFarPlaneDistance() ? event.getFarPlaneDistance() : Mth.m_144920_((float)f, (float)event.getFarPlaneDistance(), (float)fog);
                float shift = (float)((double)(active ? (fog > 0.25f ? 0.1f : 5.0E-4f) : (fog > 0.25f ? 0.001f : 1.0E-4f)) * event.getPartialTick());
                fog = active ? (fog -= shift) : (fog += shift);
                fog = Mth.m_14036_((float)fog, (float)0.0f, (float)1.0f);
                if (event.getMode() == FogRenderer.FogMode.FOG_SKY) {
                    RenderSystem.m_157445_((float)0.0f);
                    RenderSystem.m_157443_((float)f);
                } else {
                    RenderSystem.m_157445_((float)(f * 0.75f));
                    RenderSystem.m_157443_((float)f);
                }
            }
        });
        busForge.addListener(event -> {
            if (active || color > 0.0f) {
                float[] realColors = new float[]{event.getRed(), event.getGreen(), event.getBlue()};
                for (int i = 0; i < 3; ++i) {
                    float real = realColors[i];
                    float c = 0.0f;
                    VoidFog.colors[i] = real == 0.0f ? 0.0f : Mth.m_144920_((float)real, (float)0.0f, (float)color);
                }
                float shift = (float)((double)0.1f * event.getPartialTick());
                color = active ? (color += shift) : (color -= shift);
                color = Mth.m_14036_((float)color, (float)0.0f, (float)1.0f);
                event.setRed(colors[0]);
                event.setGreen(colors[1]);
                event.setBlue(colors[2]);
            }
        });
        busForge.addListener(event -> {
            if (event.player != Minecraft.m_91087_().f_91074_) {
                return;
            }
            if (event.player.f_19853_ != null && (event.player.m_20186_() <= (double)(event.player.f_19853_.m_141937_() + (Integer)Config.INSTANCE.y.get()) || VoidFog.checkForVoidscapeDimension(event.player.f_19853_))) {
                active = true;
                RandomSource random = event.player.m_217043_();
                for (int i = 0; i < 15; ++i) {
                    Vec3 vec = event.player.m_20182_().m_82520_(0.0, random.m_188500_() * 3.0, 0.0).m_82549_(new Vec3(random.m_188500_() * 6.0, 0.0, 0.0).m_82524_((float)Math.toRadians(random.m_188503_(360))));
                    event.player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123783_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
                }
            } else {
                active = false;
            }
        });
    }

    public static boolean checkForVoidscapeDimension(Level world) {
        return (Boolean)Config.INSTANCE.voidscape.get() != false && world.m_46472_().m_135782_().equals((Object)WORLD_KEY_VOID.m_135782_());
    }

    static {
        colors = new float[3];
        color = 0.0f;
        fog = 1.0f;
        WORLD_KEY_VOID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("voidscape", "void"));
    }

    static class Config {
        static Config INSTANCE;
        ForgeConfigSpec.IntValue y;
        ForgeConfigSpec.BooleanValue voidscape;

        public Config(ForgeConfigSpec.Builder builder) {
            this.y = builder.translation("voidfog.config.y").comment("The Y value in which void fog takes effect. (Min World Height + Y Value)").defineInRange("y", 12, 0, Integer.MAX_VALUE);
            this.voidscape = builder.translation("voidfog.config.voidscape").comment("Enable the effect everywhere in the mod Voidscape's main Dimension.").define("voidscape", true);
        }
    }
}

