/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.Sound.config;

import com.wynprice.Sound.MainRegistry;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SoundConfig {
    private static Boolean isClient = false;
    private static Configuration config = null;
    public static final String CATEGORY_SOUNDS_ENABLED = "Sounds that are enabled";
    public static final String CATEGORY_SERVER_SETTINGS = "Server Settings";
    public static final String CATEGORY_MODDED_BIOMES_SUPPORT = "Config for use with other mods that have biomes";
    public static Boolean isFire;
    public static Boolean isForest;
    public static Boolean isForestStorm;
    public static Boolean isBeach;
    public static Boolean isCricket;
    public static Boolean isWind;
    public static Boolean isHell;
    public static Boolean isEndDragon;
    public static Boolean isWither;
    public static Boolean isEnd;
    public static Boolean isShulkerSoundEnd;
    public static Boolean isEndCity;
    public static Boolean isStronghold;
    public static Boolean runOnServer;
    public static Boolean useList;
    public static Boolean foliage;
    public static Boolean isJungle;
    public static String[] blackServers;
    public static int[] moddedForest;
    public static int[] moddedBeach;
    public static int[] moddedStorm;
    public static int[] moddedCricket;
    public static int[] moddedNether;
    public static int[] moddedOverworld;
    public static int[] moddedEnd;
    public static int[] moddedJungle;
    public static ArrayList<String> readServers;

    public static Configuration getConfig() {
        return config;
    }

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "SoundExtended.cfg");
        config = new Configuration(configFile);
        SoundConfig.syncFromFiles();
    }

    public static void clientpreInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ConfigEventHandler());
        isClient = true;
    }

    public static void syncFromFiles() {
        SoundConfig.syncConfig(true, true);
    }

    public static void syncFromGui() {
        SoundConfig.syncConfig(false, true);
    }

    public static void syncFromFields() {
        SoundConfig.syncConfig(false, false);
    }

    private static void syncConfig(Boolean load, Boolean read) {
        if (load.booleanValue()) {
            config.load();
        }
        ArrayList<String> enabledOrder = new ArrayList<String>();
        ArrayList<String> serverOrder = new ArrayList<String>();
        ArrayList<String> moddedOrder = new ArrayList<String>();
        Property useFoliage = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "useFoliage", true);
        useFoliage.setLanguageKey("gui.useFoliage");
        useFoliage.setComment(isClient != false ? I18n.func_135052_a((String)"gui.useFoliage.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(useFoliage.getName());
        int[] emptyIntArray = new int[]{};
        Property forestBiomes = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "forestBiomes", emptyIntArray);
        forestBiomes.setLanguageKey("gui.moddedForest");
        forestBiomes.setComment(isClient != false ? I18n.func_135052_a((String)"gui.forestBiomes.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(forestBiomes.getName());
        Property cricketBiomes = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "cricketBiomes", emptyIntArray);
        cricketBiomes.setLanguageKey("gui.moddedCricket");
        cricketBiomes.setComment(isClient != false ? I18n.func_135052_a((String)"gui.moddedCricket.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(cricketBiomes.getName());
        Property stormBiomes = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "stormBiomes", emptyIntArray);
        stormBiomes.setLanguageKey("gui.moddedStorm");
        stormBiomes.setComment(isClient != false ? I18n.func_135052_a((String)"gui.moddedStorm.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(stormBiomes.getName());
        Property beachBiomes = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "beachBiomes", emptyIntArray);
        beachBiomes.setLanguageKey("gui.moddedBeach");
        beachBiomes.setComment(isClient != false ? I18n.func_135052_a((String)"gui.moddedBeach.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(beachBiomes.getName());
        Property jungleBiomes = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "moddedJungle", emptyIntArray);
        jungleBiomes.setLanguageKey("gui.moddedJungle");
        jungleBiomes.setComment(isClient != false ? I18n.func_135052_a((String)"gui.moddedJungle.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(jungleBiomes.getName());
        Property netherDimension = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "netherDimension", emptyIntArray);
        netherDimension.setLanguageKey("gui.netherDimension");
        netherDimension.setComment(isClient != false ? I18n.func_135052_a((String)"gui.netherDimension.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(netherDimension.getName());
        Property endDimension = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "endDimension", emptyIntArray);
        endDimension.setLanguageKey("gui.endDimension");
        endDimension.setComment(isClient != false ? I18n.func_135052_a((String)"gui.endDimension.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(endDimension.getName());
        Property overworldDimension = config.get(CATEGORY_MODDED_BIOMES_SUPPORT, "overworldDimension", emptyIntArray);
        overworldDimension.setLanguageKey("gui.overworldDimension");
        overworldDimension.setComment(isClient != false ? I18n.func_135052_a((String)"gui.overworldDimension.comment", (Object[])new Object[0]) : "");
        moddedOrder.add(overworldDimension.getName());
        Property useServer = config.get(CATEGORY_SERVER_SETTINGS, "useServer", true);
        useServer.setLanguageKey("gui.useServer");
        useServer.setComment(isClient != false ? I18n.func_135052_a((String)"gui.useServer.comment", (Object[])new Object[0]) : "");
        serverOrder.add(useServer.getName());
        Property useBlackList = config.get(CATEGORY_SERVER_SETTINGS, "useBlackList", true);
        useBlackList.setLanguageKey("gui.useBlackList");
        useBlackList.setComment(isClient != false ? I18n.func_135052_a((String)"gui.useBlackList.comment", (Object[])new Object[0]) : "");
        serverOrder.add(useBlackList.getName());
        String[] defaultServers = new String[]{};
        Property blackListedServers = config.get(CATEGORY_SERVER_SETTINGS, "blackListedServers", defaultServers);
        blackListedServers.setLanguageKey("gui.blackListedServers");
        blackListedServers.setComment(isClient != false ? I18n.func_135052_a((String)"gui.blackListedServers.comment", (Object[])new Object[0]) : "");
        serverOrder.add(blackListedServers.getName());
        Property isForestSound = config.get(CATEGORY_SOUNDS_ENABLED, "isForestSound", true);
        isForestSound.setLanguageKey("gui.isForest");
        isForestSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isForest.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isForestSound.getName());
        Property isBeachSound = config.get(CATEGORY_SOUNDS_ENABLED, "isBeachSound", true);
        isBeachSound.setLanguageKey("gui.isBeach");
        isBeachSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isBeach.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isBeachSound.getName());
        Property isJungleSound = config.get(CATEGORY_SOUNDS_ENABLED, "isJungle", true);
        isJungleSound.setLanguageKey("gui.isJungle");
        isJungleSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isJungle.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isJungleSound.getName());
        Property isFireSound = config.get(CATEGORY_SOUNDS_ENABLED, "isFireSound", true);
        isFireSound.setLanguageKey("gui.isFire");
        isFireSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isFire.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isFireSound.getName());
        Property isCricketSound = config.get(CATEGORY_SOUNDS_ENABLED, "isCricketSound", true);
        isCricketSound.setLanguageKey("gui.isCricket");
        isCricketSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isCricket.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isCricketSound.getName());
        Property isWindSound = config.get(CATEGORY_SOUNDS_ENABLED, "isWindSound", true);
        isWindSound.setLanguageKey("gui.isWind");
        isWindSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isWind.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isWindSound.getName());
        Property isForestStormSound = config.get(CATEGORY_SOUNDS_ENABLED, "isForestStormSound", true);
        isForestStormSound.setLanguageKey("gui.isForestStorm");
        isForestStormSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isForestStorm.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isForestStormSound.getName());
        Property isHellSound = config.get(CATEGORY_SOUNDS_ENABLED, "isHellSound", true);
        isHellSound.setLanguageKey("gui.isHell");
        isHellSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isHell.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isHellSound.getName());
        Property isEndDragonFightSound = config.get(CATEGORY_SOUNDS_ENABLED, "isEndDragon", true);
        isEndDragonFightSound.setLanguageKey("gui.isEndDragon");
        isEndDragonFightSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isEndDragon.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isEndDragonFightSound.getName());
        Property isWitherSound = config.get(CATEGORY_SOUNDS_ENABLED, "isWither", true);
        isWitherSound.setLanguageKey("gui.isWither");
        isWitherSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isWither.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isWitherSound.getName());
        Property isEndSound = config.get(CATEGORY_SOUNDS_ENABLED, "isEnd", true);
        isEndSound.setLanguageKey("gui.isEnd");
        isEndSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isEnd.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isEndSound.getName());
        Property isShulkerEndSound = config.get(CATEGORY_SOUNDS_ENABLED, "isShulkerEnd", true);
        isShulkerEndSound.setLanguageKey("gui.isShulkerEnd");
        isShulkerEndSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isShulkerEnd.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isShulkerEndSound.getName());
        Property isEndCitySound = config.get(CATEGORY_SOUNDS_ENABLED, "isEndCity", true);
        isEndCitySound.setLanguageKey("gui.isEndCity");
        isEndCitySound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isEndCity.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isEndCitySound.getName());
        Property isStrongholdSound = config.get(CATEGORY_SOUNDS_ENABLED, "isStronghold", true);
        isStrongholdSound.setLanguageKey("gui.isStronghold");
        isStrongholdSound.setComment(isClient != false ? I18n.func_135052_a((String)"gui.isStronghold.comment", (Object[])new Object[0]) : "");
        enabledOrder.add(isStrongholdSound.getName());
        config.setCategoryPropertyOrder(CATEGORY_SOUNDS_ENABLED, enabledOrder);
        config.setCategoryPropertyOrder(CATEGORY_SERVER_SETTINGS, serverOrder);
        config.setCategoryPropertyOrder(CATEGORY_MODDED_BIOMES_SUPPORT, moddedOrder);
        if (read.booleanValue()) {
            isForest = isForestSound.getBoolean();
            isBeach = isBeachSound.getBoolean();
            isJungle = isJungleSound.getBoolean();
            isFire = isFireSound.getBoolean();
            isCricket = isCricketSound.getBoolean();
            isWind = isWindSound.getBoolean();
            isForestStorm = isForestStormSound.getBoolean();
            isHell = isHellSound.getBoolean();
            isEndDragon = isEndDragonFightSound.getBoolean();
            isWither = isWitherSound.getBoolean();
            isEnd = isEndSound.getBoolean();
            isShulkerSoundEnd = isShulkerEndSound.getBoolean();
            isEndCity = isEndCitySound.getBoolean();
            isStronghold = isStrongholdSound.getBoolean();
            runOnServer = useServer.getBoolean();
            useList = useBlackList.getBoolean();
            blackServers = blackListedServers.getStringList();
            moddedBeach = beachBiomes.getIntList();
            moddedCricket = cricketBiomes.getIntList();
            moddedJungle = jungleBiomes.getIntList();
            moddedStorm = stormBiomes.getIntList();
            moddedForest = forestBiomes.getIntList();
            moddedNether = netherDimension.getIntList();
            moddedEnd = endDimension.getIntList();
            moddedOverworld = overworldDimension.getIntList();
            foliage = useFoliage.getBoolean();
        }
        isForestSound.set(isForest.booleanValue());
        isBeachSound.set(isBeach.booleanValue());
        isJungleSound.set(isJungle.booleanValue());
        isFireSound.set(isFire.booleanValue());
        isCricketSound.set(isCricket.booleanValue());
        isWindSound.set(isWind.booleanValue());
        isForestStormSound.set(isForestStorm.booleanValue());
        isHellSound.set(isHell.booleanValue());
        isEndDragonFightSound.set(isEndDragon.booleanValue());
        isWindSound.set(isWither.booleanValue());
        isEndSound.set(isEnd.booleanValue());
        isShulkerEndSound.set(isShulkerSoundEnd.booleanValue());
        isEndCitySound.set(isEndCity.booleanValue());
        isStrongholdSound.set(isStronghold.booleanValue());
        useServer.set(runOnServer.booleanValue());
        useBlackList.set(useList.booleanValue());
        blackListedServers.set(blackServers);
        beachBiomes.set(moddedBeach);
        cricketBiomes.set(moddedCricket);
        jungleBiomes.set(moddedJungle);
        stormBiomes.set(moddedStorm);
        forestBiomes.set(moddedForest);
        netherDimension.set(moddedNether);
        endDimension.set(moddedEnd);
        overworldDimension.set(moddedOverworld);
        useFoliage.set(foliage.booleanValue());
        readServers.clear();
        for (String IP : blackServers) {
            Boolean isError = false;
            InetAddress address = null;
            try {
                address = InetAddress.getByName(new URL("http://" + IP).getHost());
            }
            catch (UnknownHostException e) {
                MainRegistry.getlogger().info("Error in config: Ip '" + IP + "' does not exist");
                isError = true;
            }
            catch (MalformedURLException e) {
                MainRegistry.getlogger().info("Error in config: Ip '" + IP + "' is not valid");
                isError = true;
            }
            if (isError.booleanValue()) continue;
            readServers.add(address.getHostAddress());
        }
        if (readServers.size() != 0) {
            MainRegistry.getlogger().info("Block IP's:" + readServers);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        readServers = new ArrayList();
    }

    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID() == "sounds_extended") {
                SoundConfig.syncFromGui();
            }
        }
    }
}

