/*
 * Decompiled with CFR 0.152.
 */
package clickme.nocubes;

import clickme.nocubes.NoCubes;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class SmoothBlockRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int meta, int model, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (renderer.field_147844_c) {
            int color = block.func_149741_i(meta);
            float colorRed = (float)(color >> 16 & 0xFF) / 255.0f;
            float colorGreen = (float)(color >> 8 & 0xFF) / 255.0f;
            float colorBlue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorRed, (float)colorGreen, (float)colorBlue, (float)1.0f);
        }
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory(int meta) {
        return true;
    }

    public int getRenderId() {
        return NoCubes.renderId;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int model, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int color = block.func_149720_d(world, x, y, z);
        float colorRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorBlue = (float)(color & 0xFF) / 255.0f;
        float shadowBottom = 0.8f;
        float shadowTop = 1.0f;
        float shadowLeft = 0.95f;
        float shadowRight = 0.9f;
        IIcon icon = !renderer.func_147744_b() ? renderer.func_147777_a(block, 0) : renderer.field_147840_d;
        double minU = icon.func_94209_e();
        double minV = icon.func_94206_g();
        double maxU = icon.func_94212_f();
        double maxV = icon.func_94210_h();
        Vec3[] points = new Vec3[]{world.func_82732_R().func_72345_a(0.0, 0.0, 0.0), world.func_82732_R().func_72345_a(1.0, 0.0, 0.0), world.func_82732_R().func_72345_a(1.0, 0.0, 1.0), world.func_82732_R().func_72345_a(0.0, 0.0, 1.0), world.func_82732_R().func_72345_a(0.0, 1.0, 0.0), world.func_82732_R().func_72345_a(1.0, 1.0, 0.0), world.func_82732_R().func_72345_a(1.0, 1.0, 1.0), world.func_82732_R().func_72345_a(0.0, 1.0, 1.0)};
        for (int point = 0; point < 8; ++point) {
            points[point].field_72450_a += (double)x;
            points[point].field_72448_b += (double)y;
            points[point].field_72449_c += (double)z;
            if (SmoothBlockRenderer.doesPointIntersectWithManufactured(world, points[point])) continue;
            if (point < 4 && SmoothBlockRenderer.doesPointBottomIntersectWithAir(world, points[point])) {
                points[point].field_72448_b = (double)y + 1.0;
            } else if (point >= 4 && SmoothBlockRenderer.doesPointTopIntersectWithAir(world, points[point])) {
                points[point].field_72448_b = (double)y + 0.0;
            }
            points[point] = this.givePointRoughness(points[point]);
        }
        for (int side = 0; side < 6; ++side) {
            int facingX = x;
            int facingY = y;
            int facingZ = z;
            if (side == 0) {
                --facingY;
            } else if (side == 1) {
                ++facingY;
            } else if (side == 2) {
                --facingZ;
            } else if (side == 3) {
                ++facingX;
            } else if (side == 4) {
                ++facingZ;
            } else if (side == 5) {
                --facingX;
            }
            if (!renderer.field_147837_f && !block.func_149646_a(world, facingX, facingY, facingZ, side)) continue;
            float colorFactor = 1.0f;
            Vec3 vertex0 = null;
            Vec3 vertex1 = null;
            Vec3 vertex2 = null;
            Vec3 vertex3 = null;
            if (side == 0) {
                colorFactor = shadowBottom;
                vertex0 = points[0];
                vertex1 = points[1];
                vertex2 = points[2];
                vertex3 = points[3];
            } else if (side == 1) {
                colorFactor = points[1].field_72448_b == points[5].field_72448_b ? shadowLeft : (points[2].field_72448_b == points[6].field_72448_b ? shadowLeft : shadowTop);
                vertex0 = points[7];
                vertex1 = points[6];
                vertex2 = points[5];
                vertex3 = points[4];
            } else if (side == 2) {
                colorFactor = shadowLeft;
                vertex0 = points[1];
                vertex1 = points[0];
                vertex2 = points[4];
                vertex3 = points[5];
            } else if (side == 3) {
                colorFactor = shadowRight;
                vertex0 = points[2];
                vertex1 = points[1];
                vertex2 = points[5];
                vertex3 = points[6];
            } else if (side == 4) {
                colorFactor = shadowLeft;
                vertex0 = points[3];
                vertex1 = points[2];
                vertex2 = points[6];
                vertex3 = points[7];
            } else if (side == 5) {
                colorFactor = shadowRight;
                vertex0 = points[0];
                vertex1 = points[3];
                vertex2 = points[7];
                vertex3 = points[4];
            }
            tessellator.func_78380_c(block.func_149677_c(world, facingX, facingY, facingZ));
            tessellator.func_78386_a(shadowTop * colorFactor * colorRed, shadowTop * colorFactor * colorGreen, shadowTop * colorFactor * colorBlue);
            tessellator.func_78374_a(vertex0.field_72450_a, vertex0.field_72448_b, vertex0.field_72449_c, minU, maxV);
            tessellator.func_78374_a(vertex1.field_72450_a, vertex1.field_72448_b, vertex1.field_72449_c, maxU, maxV);
            tessellator.func_78374_a(vertex2.field_72450_a, vertex2.field_72448_b, vertex2.field_72449_c, maxU, minV);
            tessellator.func_78374_a(vertex3.field_72450_a, vertex3.field_72448_b, vertex3.field_72449_c, minU, minV);
        }
        return true;
    }

    private Vec3 givePointRoughness(Vec3 point) {
        long i = (long)(point.field_72450_a * 3129871.0) ^ (long)point.field_72448_b * 116129781L ^ (long)point.field_72449_c;
        i = i * i * 42317861L + i * 11L;
        point.field_72450_a += (double)(((float)(i >> 16 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        point.field_72448_b += (double)(((float)(i >> 20 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        point.field_72449_c += (double)(((float)(i >> 24 & 0xFL) / 15.0f - 0.5f) * 0.5f);
        return point;
    }

    public static boolean isBlockAirOrPlant(Block block) {
        Material material = block.func_149688_o();
        return material == Material.field_151579_a || material == Material.field_151585_k || material == Material.field_151582_l;
    }

    public static boolean doesPointTopIntersectWithAir(IBlockAccess world, Vec3 point) {
        boolean intersects = false;
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.field_72450_a - (double)(i & 1));
            int z1 = (int)(point.field_72449_c - (double)(i >> 1 & 1));
            if (!SmoothBlockRenderer.isBlockAirOrPlant(world.func_147439_a(x1, (int)point.field_72448_b, z1))) {
                return false;
            }
            if (!SmoothBlockRenderer.isBlockAirOrPlant(world.func_147439_a(x1, (int)point.field_72448_b - 1, z1))) continue;
            intersects = true;
        }
        return intersects;
    }

    public static boolean doesPointBottomIntersectWithAir(IBlockAccess world, Vec3 point) {
        boolean intersects = false;
        boolean notOnly = false;
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.field_72450_a - (double)(i & 1));
            int z1 = (int)(point.field_72449_c - (double)(i >> 1 & 1));
            if (!SmoothBlockRenderer.isBlockAirOrPlant(world.func_147439_a(x1, (int)point.field_72448_b - 1, z1))) {
                return false;
            }
            if (!SmoothBlockRenderer.isBlockAirOrPlant(world.func_147439_a(x1, (int)point.field_72448_b + 1, z1))) {
                notOnly = true;
            }
            if (!SmoothBlockRenderer.isBlockAirOrPlant(world.func_147439_a(x1, (int)point.field_72448_b, z1))) continue;
            intersects = true;
        }
        return intersects && notOnly;
    }

    public static boolean doesPointIntersectWithManufactured(IBlockAccess world, Vec3 point) {
        for (int i = 0; i < 4; ++i) {
            int x1 = (int)(point.field_72450_a - (double)(i & 1));
            int z1 = (int)(point.field_72449_c - (double)(i >> 1 & 1));
            Block block = world.func_147439_a(x1, (int)point.field_72448_b, z1);
            if (!SmoothBlockRenderer.isBlockAirOrPlant(block) && !NoCubes.isBlockSmoothed(block)) {
                return true;
            }
            Block block1 = world.func_147439_a(x1, (int)point.field_72448_b - 1, z1);
            if (SmoothBlockRenderer.isBlockAirOrPlant(block1) || NoCubes.isBlockSmoothed(block1)) continue;
            return true;
        }
        return false;
    }
}

