/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.chunk;

import esvdefcon.skyline.chunk.AssembleResult;
import esvdefcon.skyline.chunk.LocatedBlock;
import esvdefcon.skyline.chunk.ShipSizeOverflowException;
import esvdefcon.skyline.common.Skyline;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChunkAssembler {
    private World worldObj;
    public final int startX;
    public final int startY;
    public final int startZ;
    private final int maxBlocks;

    public ChunkAssembler(World world, int x, int y, int z) {
        this.worldObj = world;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.maxBlocks = Skyline.instance.modConfig.maxShipChunkBlocks;
    }

    public AssembleResult doAssemble() {
        AssembleResult result = new AssembleResult();
        result.xOffset = this.startX;
        result.yOffset = this.startY;
        result.zOffset = this.startZ;
        try {
            if (Skyline.instance.modConfig.useNewAlgorithm) {
                this.assembleIterative(result, this.startX, this.startY, this.startZ);
            } else {
                this.assembleRecursive(result, new HashSet<ChunkPosition>(), this.startX, this.startY, this.startZ);
            }
            result.resultCode = result.shipMarkingBlock == null ? 3 : 1;
        }
        catch (ShipSizeOverflowException e) {
            result.resultCode = 2;
        }
        catch (Error e) {
            Skyline.modLog.error("Error while compiling ship", (Throwable)e);
            result.resultCode = 4;
        }
        return result;
    }

    private void assembleIterative(AssembleResult result, int sx, int sy, int sz) throws ShipSizeOverflowException {
        HashSet<ChunkPosition> openset = new HashSet<ChunkPosition>();
        HashSet<ChunkPosition> closedset = new HashSet<ChunkPosition>();
        ArrayList<ChunkPosition> iterator = new ArrayList<ChunkPosition>();
        int x = sx;
        int y = sy;
        int z = sz;
        openset.add(new ChunkPosition(sx, sy, sz));
        while (!openset.isEmpty()) {
            iterator.addAll(openset);
            for (ChunkPosition pos : iterator) {
                openset.remove(pos);
                if (closedset.contains(pos)) continue;
                if (result.assembledBlocks.size() > this.maxBlocks) {
                    throw new ShipSizeOverflowException();
                }
                x = pos.field_151329_a;
                y = pos.field_151327_b;
                z = pos.field_151328_c;
                closedset.add(pos);
                Block block = this.worldObj.func_147439_a(x, y, z);
                if (!this.canUseBlockForVehicle(block, x, y, z)) continue;
                LocatedBlock lb = new LocatedBlock(block, this.worldObj.func_72805_g(x, y, z), this.worldObj.func_147438_o(x, y, z), pos);
                result.assembleBlock(lb);
                if (block == Skyline.blockMarkShip && result.shipMarkingBlock == null) {
                    result.shipMarkingBlock = lb;
                }
                openset.add(new ChunkPosition(x - 1, y, z));
                openset.add(new ChunkPosition(x, y - 1, z));
                openset.add(new ChunkPosition(x, y, z - 1));
                openset.add(new ChunkPosition(x + 1, y, z));
                openset.add(new ChunkPosition(x, y + 1, z));
                openset.add(new ChunkPosition(x, y, z + 1));
                if (!Skyline.instance.modConfig.connectDiagonalBlocks1) continue;
                openset.add(new ChunkPosition(x - 1, y - 1, z));
                openset.add(new ChunkPosition(x + 1, y - 1, z));
                openset.add(new ChunkPosition(x + 1, y + 1, z));
                openset.add(new ChunkPosition(x - 1, y + 1, z));
                openset.add(new ChunkPosition(x - 1, y, z - 1));
                openset.add(new ChunkPosition(x + 1, y, z - 1));
                openset.add(new ChunkPosition(x + 1, y, z + 1));
                openset.add(new ChunkPosition(x - 1, y, z + 1));
                openset.add(new ChunkPosition(x, y - 1, z - 1));
                openset.add(new ChunkPosition(x, y + 1, z - 1));
                openset.add(new ChunkPosition(x, y + 1, z + 1));
                openset.add(new ChunkPosition(x, y - 1, z + 1));
            }
        }
    }

    private void assembleRecursive(AssembleResult result, HashSet<ChunkPosition> set, int x, int y, int z) throws ShipSizeOverflowException {
        if (result.assembledBlocks.size() > this.maxBlocks) {
            throw new ShipSizeOverflowException();
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        Block block = this.worldObj.func_147439_a(x, y, z);
        if (!this.canUseBlockForVehicle(block, x, y, z)) {
            return;
        }
        LocatedBlock lb = new LocatedBlock(block, this.worldObj.func_72805_g(x, y, z), this.worldObj.func_147438_o(x, y, z), pos);
        result.assembleBlock(lb);
        if (block == Skyline.blockMarkShip && result.shipMarkingBlock == null) {
            result.shipMarkingBlock = lb;
        }
        this.assembleRecursive(result, set, x - 1, y, z);
        this.assembleRecursive(result, set, x, y - 1, z);
        this.assembleRecursive(result, set, x, y, z - 1);
        this.assembleRecursive(result, set, x + 1, y, z);
        this.assembleRecursive(result, set, x, y + 1, z);
        this.assembleRecursive(result, set, x, y, z + 1);
        if (Skyline.instance.modConfig.connectDiagonalBlocks1) {
            this.assembleRecursive(result, set, x - 1, y - 1, z);
            this.assembleRecursive(result, set, x + 1, y - 1, z);
            this.assembleRecursive(result, set, x + 1, y + 1, z);
            this.assembleRecursive(result, set, x - 1, y + 1, z);
            this.assembleRecursive(result, set, x - 1, y, z - 1);
            this.assembleRecursive(result, set, x + 1, y, z - 1);
            this.assembleRecursive(result, set, x + 1, y, z + 1);
            this.assembleRecursive(result, set, x - 1, y, z + 1);
            this.assembleRecursive(result, set, x, y - 1, z - 1);
            this.assembleRecursive(result, set, x, y + 1, z - 1);
            this.assembleRecursive(result, set, x, y + 1, z + 1);
            this.assembleRecursive(result, set, x, y - 1, z + 1);
        }
    }

    public boolean canUseBlockForVehicle(Block block, int x, int y, int z) {
        return !block.isAir((IBlockAccess)this.worldObj, x, y, z) && !block.func_149688_o().func_76224_d() && block != Skyline.blockBuffer && Skyline.instance.modConfig.isBlockAllowed(block);
    }
}

