/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.chunk;

import esvdefcon.skyline.chunk.MobileChunk;
import esvdefcon.skyline.common.Skyline;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkPosition;

public abstract class ChunkIO {
    public static void write(DataOutput out, MobileChunk chunk, Collection<ChunkPosition> blocks) throws IOException {
        out.writeShort(blocks.size());
        for (ChunkPosition p : blocks) {
            ChunkIO.writeBlock(out, chunk, p.field_151329_a, p.field_151327_b, p.field_151328_c);
        }
    }

    public static int writeAll(DataOutput out, MobileChunk chunk) throws IOException {
        Block block;
        int k;
        int j;
        int i;
        int count = 0;
        for (i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    block = chunk.func_147439_a(i, j, k);
                    if (block == Blocks.field_150350_a) continue;
                    ++count;
                }
            }
        }
        Skyline.modLog.debug("Writing mobile chunk data: " + count + " blocks");
        out.writeShort(count);
        for (i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    block = chunk.func_147439_a(i, j, k);
                    if (block == Blocks.field_150350_a) continue;
                    ChunkIO.writeBlock(out, Block.func_149682_b((Block)block), chunk.func_72805_g(i, j, k), i, j, k);
                }
            }
        }
        return count;
    }

    public static void writeBlock(DataOutput out, MobileChunk chunk, int x, int y, int z) throws IOException {
        ChunkIO.writeBlock(out, Block.func_149682_b((Block)chunk.func_147439_a(x, y, z)), chunk.func_72805_g(x, y, z), x, y, z);
    }

    public static void writeBlock(DataOutput out, int id, int meta, int x, int y, int z) throws IOException {
        out.writeByte(x);
        out.writeByte(y);
        out.writeByte(z);
        out.writeShort(id);
        out.writeInt(meta);
    }

    public static void read(DataInput in, MobileChunk chunk) throws IOException {
        int count = in.readShort();
        Skyline.modLog.debug("Reading mobile chunk data: " + count + " blocks");
        for (int i = 0; i < count; ++i) {
            byte x = in.readByte();
            byte y = in.readByte();
            byte z = in.readByte();
            short id = in.readShort();
            int meta = in.readInt();
            chunk.setBlockIDWithMetadata(x, y, z, Block.func_149729_e((int)id), meta);
        }
    }

    public static void writeCompressed(ByteBuf buf, MobileChunk chunk, Collection<ChunkPosition> blocks) throws IOException {
        DataOutputStream out = ChunkIO.preCompress(buf);
        ChunkIO.write(out, chunk, blocks);
        ChunkIO.postCompress(buf, out, blocks.size());
    }

    public static void writeAllCompressed(ByteBuf buf, MobileChunk chunk) throws IOException {
        DataOutputStream out = ChunkIO.preCompress(buf);
        int count = ChunkIO.writeAll(out, chunk);
        ChunkIO.postCompress(buf, out, count);
    }

    private static DataOutputStream preCompress(ByteBuf data) throws IOException {
        ByteBufOutputStream bbos = new ByteBufOutputStream(data);
        DataOutputStream out = new DataOutputStream(new GZIPOutputStream((OutputStream)bbos));
        return out;
    }

    private static void postCompress(ByteBuf data, DataOutputStream out, int count) throws IOException {
        out.flush();
        out.close();
        int byteswritten = data.writerIndex();
        float f = (float)byteswritten / (float)(count * 9);
        Skyline.modLog.debug(String.format(Locale.ENGLISH, "%d blocks written. Efficiency: %d/%d = %.2f", count, byteswritten, count * 9, Float.valueOf(f)));
        if (byteswritten > 32000) {
            Skyline.modLog.warn("Ship probably contains too many blocks");
        }
    }

    public static void readCompressed(ByteBuf data, MobileChunk chunk) throws IOException {
        DataInputStream in = new DataInputStream(new GZIPInputStream((InputStream)new ByteBufInputStream(data)));
        ChunkIO.read(in, chunk);
        in.close();
    }
}

