/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.common;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import esvdefcon.skyline.blockitem.BlockGauge;
import esvdefcon.skyline.blockitem.BlockHelm;
import esvdefcon.skyline.blockitem.BlockSeat;
import esvdefcon.skyline.blockitem.TileEntityHelm;
import esvdefcon.skyline.command.CommandASHelp;
import esvdefcon.skyline.command.CommandDisassembleNear;
import esvdefcon.skyline.command.CommandDisassembleShip;
import esvdefcon.skyline.command.CommandShipInfo;
import esvdefcon.skyline.command.CommandShipSpeed;
import esvdefcon.skyline.common.CommonProxy;
import esvdefcon.skyline.common.SkylineConfig;
import esvdefcon.skyline.entity.EntityEntityAttachment;
import esvdefcon.skyline.entity.EntitySeat;
import esvdefcon.skyline.entity.EntityShip;
import esvdefcon.skyline.mrot.MetaRotations;
import esvdefcon.skyline.network.ASMessagePipeline;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Logger;

@Mod(modid="skyline", name="1.0.0 Pre-Alpha", version="EsvDefcon's Skyline Mod")
public class Skyline {
    public static final String modid = "skyline";
    public static final String name = "1.0.0 Pre-Alpha";
    public static final String version = "EsvDefcon's Skyline Mod";
    @Mod.Instance(value="skyline")
    public static Skyline instance;
    @SidedProxy(clientSide="esvdefcon.skyline.common.ClientProxy", serverSide="esvdefcon.skyline.common.CommonProxy")
    public static CommonProxy proxy;
    public static Logger modLog;
    public static BlockHelm blockMarkShip;
    public static Block blockFloater;
    public static Block blockBalloon;
    public static BlockGauge blockGauge;
    public static BlockSeat blockSeat;
    public static Block blockBuffer;
    public static Block blockEngine;
    public static Block blockCrateWood;
    public static Material materialFloater;
    public SkylineConfig modConfig;
    public ASMessagePipeline pipeline = new ASMessagePipeline();
    public MetaRotations metaRotations = new MetaRotations();

    @Mod.EventHandler
    public void preInitMod(FMLPreInitializationEvent event) {
        modLog = event.getModLog();
        this.modConfig = new SkylineConfig(new Configuration(event.getSuggestedConfigurationFile()));
        this.modConfig.loadAndSave();
        this.metaRotations.setConfigDirectory(event.getModConfigurationDirectory());
        this.pipeline.initalize();
        this.createBlocksAndItems();
        this.modConfig.postLoad();
    }

    private void createBlocksAndItems() {
        materialFloater = new Material(MapColor.field_151659_e);
        blockMarkShip = (BlockHelm)new BlockHelm().func_149647_a(CreativeTabs.field_78029_e);
        blockMarkShip.func_149672_a(Block.field_149766_f).func_149711_c(1.0f).func_149752_b(1.0f);
        this.registerBlock("marker", (Block)blockMarkShip);
        blockBalloon = new BlockColored(Material.field_151580_n).func_149647_a(CreativeTabs.field_78029_e);
        blockBalloon.func_149672_a(Block.field_149775_l).func_149711_c(0.35f).func_149752_b(1.0f);
        this.registerBlock("balloon", blockBalloon, ItemCloth.class);
    }

    private void registerBlocksAndItems() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)blockMarkShip, 1), (Object[])new Object[]{"X#X", "#O#", "X#X", Character.valueOf('X'), Blocks.field_150344_f, Character.valueOf('#'), Items.field_151137_ax, Character.valueOf('O'), Items.field_151045_i});
        GameRegistry.registerTileEntity(TileEntityHelm.class, (String)"archiHelm");
        Blocks.field_150480_ab.setFireInfo((Block)blockMarkShip, 5, 5);
        for (int i = 0; i < ItemDye.field_150923_a.length; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(blockBalloon, 1, i), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack(Blocks.field_150325_L, 1, i)});
        }
        Blocks.field_150480_ab.setFireInfo(blockBalloon, 30, 60);
    }

    @Mod.EventHandler
    public void initMod(FMLInitializationEvent event) {
        this.registerBlocksAndItems();
        EntityRegistry.registerModEntity(EntityShip.class, (String)"shipmod", (int)1, (Object)this, (int)64, (int)this.modConfig.shipEntitySyncRate, (boolean)true);
        EntityRegistry.registerModEntity(EntityEntityAttachment.class, (String)"attachment", (int)2, (Object)this, (int)64, (int)100, (boolean)false);
        EntityRegistry.registerModEntity(EntitySeat.class, (String)"attachment.seat", (int)3, (Object)this, (int)64, (int)100, (boolean)false);
        proxy.registerKeyHandlers(this.modConfig);
        proxy.registerEventHandlers();
        proxy.registerRenderers();
        proxy.registerPackets(this.pipeline);
    }

    @Mod.EventHandler
    public void postInitMod(FMLPostInitializationEvent event) {
        this.metaRotations.readMetaRotationFiles();
        this.pipeline.postInitialize();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.registerASCommand(event, new CommandASHelp());
        this.registerASCommand(event, new CommandDisassembleShip());
        this.registerASCommand(event, new CommandShipInfo());
        this.registerASCommand(event, new CommandShipSpeed());
        this.registerASCommand(event, new CommandDisassembleNear());
        Collections.sort(CommandASHelp.asCommands);
    }

    private void registerASCommand(FMLServerStartingEvent event, CommandBase commandbase) {
        event.registerServerCommand((ICommand)commandbase);
        CommandASHelp.asCommands.add(commandbase);
    }

    private void registerBlock(String id, Block block) {
        this.registerBlock(id, block, ItemBlock.class);
    }

    private void registerBlock(String id, Block block, Class<? extends ItemBlock> itemblockclass) {
        block.func_149663_c("archimedes." + id);
        block.func_149658_d("skyline:" + id);
        GameRegistry.registerBlock((Block)block, itemblockclass, (String)id);
    }
}

