/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import esvdefcon.skyline.chunk.AssembleResult;
import esvdefcon.skyline.common.MaterialDensity;
import esvdefcon.skyline.common.Skyline;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class SkylineConfig {
    public static final int CONTROL_TYPE_VANILLA = 0;
    public static final int CONTROL_TYPE_ARCHIMEDES = 1;
    private Configuration config;
    private String[] loadedBlockDensities;
    private String[] loadedMaterialDensities;
    public boolean enableAirShips;
    public int shipEntitySyncRate;
    public int maxShipChunkBlocks;
    public float flyBalloonRatio;
    public boolean connectDiagonalBlocks1;
    public boolean connectDiagonalBlocks2;
    public boolean useWhitelist;
    public Set<String> blockBlacklist;
    public Set<String> blockWhitelist;
    public Set<String> overwritableBlocks;
    public boolean useNewAlgorithm;
    public int shipControlType;
    public float turnSpeed;
    public float speedLimit;
    public float bankingMultiplier;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbUp;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDown;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbBrake;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbAlign;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDisassemble;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbShipInv;
    public boolean disassembleOnDismount;

    public SkylineConfig(Configuration configuration) {
        this.config = configuration;
        this.blockBlacklist = new HashSet<String>();
        this.blockWhitelist = new HashSet<String>();
        this.overwritableBlocks = new HashSet<String>();
    }

    public void loadAndSave() {
        Block[] defaultBlockBlacklist = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150392_bi, Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150329_H};
        Block[] defaultBlocksWhitelist = new Block[]{Blocks.field_150400_ck, Blocks.field_150408_cc, Blocks.field_150467_bQ, Blocks.field_150324_C, Blocks.field_150487_bG, Blocks.field_150342_X, Blocks.field_150382_bo, Blocks.field_150336_V, Blocks.field_150389_bf, Blocks.field_150434_aF, Blocks.field_150414_aQ, Blocks.field_150404_cg, Blocks.field_150402_ci, Blocks.field_150347_e, Blocks.field_150463_bK, Blocks.field_150483_bI, Blocks.field_150462_ai, Blocks.field_150401_cl, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150367_z, Blocks.field_150409_cd, Blocks.field_150453_bW, Blocks.field_150334_T, Blocks.field_150373_bw, Blocks.field_150475_bE, Blocks.field_150381_bn, Blocks.field_150377_bs, Blocks.field_150477_bB, Blocks.field_150422_aJ, Blocks.field_150396_be, Blocks.field_150457_bL, Blocks.field_150460_al, Blocks.field_150480_ab, Blocks.field_150359_w, Blocks.field_150410_aZ, Blocks.field_150426_aN, Blocks.field_150340_R, Blocks.field_150318_D, Blocks.field_150405_ch, Blocks.field_150407_cf, Blocks.field_150443_bT, Blocks.field_150438_bZ, Blocks.field_150411_aY, Blocks.field_150339_S, Blocks.field_150454_av, Blocks.field_150421_aI, Blocks.field_150481_bH, Blocks.field_150468_ap, Blocks.field_150368_y, Blocks.field_150442_at, Blocks.field_150445_bS, Blocks.field_150470_am, Blocks.field_150428_aP, Blocks.field_150374_bv, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150440_ba, Blocks.field_150474_ac, Blocks.field_150418_aU, Blocks.field_150341_Y, Blocks.field_150385_bj, Blocks.field_150386_bk, Blocks.field_150387_bl, Blocks.field_150323_B, Blocks.field_150476_ad, Blocks.field_150343_Z, Blocks.field_150344_f, Blocks.field_150423_aK, Blocks.field_150331_J, Blocks.field_150326_M, Blocks.field_150332_K, Blocks.field_150455_bV, Blocks.field_150416_aS, Blocks.field_150371_ca, Blocks.field_150370_cb, Blocks.field_150448_aq, Blocks.field_150451_bX, Blocks.field_150429_aA, Blocks.field_150488_af, Blocks.field_150322_A, Blocks.field_150372_bz, Blocks.field_150465_bP, Blocks.field_150360_v, Blocks.field_150485_bF, Blocks.field_150406_ce, Blocks.field_150472_an, Blocks.field_150390_bg, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_150446_ar, Blocks.field_150417_aV, Blocks.field_150399_cn, Blocks.field_150397_co, Blocks.field_150320_F, Blocks.field_150333_U, Blocks.field_150335_W, Blocks.field_150478_aa, Blocks.field_150415_aT, Blocks.field_150447_bR, Blocks.field_150473_bD, Blocks.field_150479_bC, Blocks.field_150437_az, Blocks.field_150441_bU, Blocks.field_150413_aR, Blocks.field_150444_as, Blocks.field_150321_G, Blocks.field_150471_bO, Blocks.field_150466_ao, Blocks.field_150452_aw, Blocks.field_150325_L, Blocks.field_150376_bx};
        Block[] defaultOverwritableBlocks = new Block[]{Blocks.field_150329_H, Blocks.field_150392_bi};
        String[] defaultMaterialDensities = new String[]{"\"minecraft:air=0.0\"", "\"minecraft:wool=0.1\""};
        String[] defaultBlockDensities = new String[]{"\"ArchimedesShips:floater=0.04\"", "\"ArchimedesShips:balloon=0.02\""};
        String[] blockblacklistnames = new String[defaultBlockBlacklist.length];
        for (int i = 0; i < defaultBlockBlacklist.length; ++i) {
            blockblacklistnames[i] = Block.field_149771_c.func_148750_c((Object)defaultBlockBlacklist[i]);
        }
        String[] blockwhitelistnames = new String[6 + defaultBlocksWhitelist.length];
        for (int i = 0; i < blockwhitelistnames.length - 6; ++i) {
            blockwhitelistnames[i] = Block.field_149771_c.func_148750_c((Object)defaultBlocksWhitelist[i]);
        }
        blockwhitelistnames[blockwhitelistnames.length - 6] = "ArchimedesShips:marker";
        blockwhitelistnames[blockwhitelistnames.length - 5] = "ArchimedesShips:floater";
        blockwhitelistnames[blockwhitelistnames.length - 4] = "ArchimedesShips:balloon";
        blockwhitelistnames[blockwhitelistnames.length - 3] = "ArchimedesShips:gauge";
        blockwhitelistnames[blockwhitelistnames.length - 2] = "ArchimedesShips:seat";
        blockwhitelistnames[blockwhitelistnames.length - 1] = "ArchimedesShips:engine";
        String[] overwritableblocksnames = new String[defaultOverwritableBlocks.length];
        for (int i = 0; i < defaultOverwritableBlocks.length; ++i) {
            overwritableblocksnames[i] = Block.field_149771_c.func_148750_c((Object)defaultOverwritableBlocks[i]);
        }
        this.config.load();
        this.shipEntitySyncRate = this.config.get("settings", "sync_rate", 20, "20 ticks = 1 second").getInt();
        this.enableAirShips = this.config.get("settings", "enable_air_ships", true, "Enable or disable flight (limit ships to ground).").getBoolean(true);
        this.useNewAlgorithm = this.config.get("settings", "use_iterative_assemble_algorithm", false, "Allows larger ships to be created.").getBoolean(false);
        this.bankingMultiplier = (float)this.config.get("settings", "banking_multiplier", AssembleResult.getAgilityRatingForConfig() / 20, "How much ships bank while turning. 0 disables banking.").getDouble(3.0);
        this.shipControlType = this.config.get("control", "control_type", 1, "Set to 0 to use vanilla boat controls, set to 1 to use mod controls.").getInt();
        this.turnSpeed = (float)this.config.get("control", "turn_speed", 1.0, "Set the turning speed for ships.").getDouble(1.0);
        this.speedLimit = (float)this.config.get("control", "speed_limit", 30.0, "Limit the maximum speed for all ships (blocks/s).").getDouble(30.0);
        this.speedLimit /= 20.0f;
        this.disassembleOnDismount = this.config.get("control", "decompile_on_dismount", false).getBoolean(false);
        this.maxShipChunkBlocks = this.config.get("mobile_chunk", "max_chunk_blocks", 3072, "Limit the amount of blocks a ship can have.").getInt();
        this.flyBalloonRatio = (float)this.config.get("mobile_chunk", "airship_balloon_ratio", 0.3, "The ratio of balloons needed to make an airship float.").getDouble(0.4);
        this.connectDiagonalBlocks1 = this.config.get("mobile_chunk", "connect_diagonal_blocks_1", false, "If true, allows blocks to be connected diagonally (but only on one axis).").getBoolean(false);
        this.useWhitelist = this.config.get("mobile_chunk", "use_whitelist", false, "Use predefined block whitelists and blacklists.").getBoolean(false);
        String[] forbiddenblocks = this.config.get("mobile_chunk", "forbidden_blocks", blockblacklistnames, "Block blacklist.").getStringList();
        String[] allowedblocks = this.config.get("mobile_chunk", "allowed_blocks", blockwhitelistnames, "Block whitelist.").getStringList();
        String[] overwritableblocks = this.config.get("mobile_chunk", "overwritable_blocks", overwritableblocksnames, "Blocks to overwrite when a ship is docked.").getStringList();
        Collections.addAll(this.blockBlacklist, forbiddenblocks);
        Collections.addAll(this.blockWhitelist, allowedblocks);
        Collections.addAll(this.overwritableBlocks, overwritableblocks);
        this.loadedBlockDensities = this.config.get("mobile_chunk", "block_densities", defaultBlockDensities, "Material density list.").getStringList();
        this.loadedMaterialDensities = this.config.get("mobile_chunk", "material_densities", defaultMaterialDensities, "Updated material density list.").getStringList();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.loadKeybindings();
        }
        this.config.save();
    }

    public void postLoad() {
        Block block;
        float density;
        String key;
        String[] pair;
        String s;
        int i;
        Pattern splitpattern = Pattern.compile("=");
        for (i = 0; i < this.loadedBlockDensities.length; ++i) {
            s = this.loadedBlockDensities[i];
            pair = splitpattern.split(s = s.replace("\"", ""));
            if (pair.length != 2) {
                Skyline.modLog.warn("Invalid key-value pair at block_densities[" + i + "]");
                continue;
            }
            key = pair[0];
            try {
                density = Float.parseFloat(pair[1]);
            }
            catch (NumberFormatException e) {
                Skyline.modLog.warn("Cannot parse value " + pair[1] + " to floating point at block_densities[" + i + "]");
                continue;
            }
            block = Block.func_149684_b((String)key);
            if (block == null) {
                Skyline.modLog.warn("No block found for " + key + " at block_densities[" + i + "]");
                continue;
            }
            MaterialDensity.addDensity(block, density);
        }
        for (i = 0; i < this.loadedMaterialDensities.length; ++i) {
            s = this.loadedMaterialDensities[i];
            pair = splitpattern.split(s = s.replace("\"", ""));
            if (pair.length != 2) {
                Skyline.modLog.warn("Invalid key-value pair at material_densities[" + i + "]");
                continue;
            }
            key = pair[0];
            try {
                density = Float.parseFloat(pair[1]);
            }
            catch (NumberFormatException e) {
                Skyline.modLog.warn("Cannot parse value " + pair[1] + " to floating point at material_densities[" + i + "]");
                continue;
            }
            block = Block.func_149684_b((String)key);
            if (block == null) {
                Skyline.modLog.warn("No block found for " + key + " at material_densities[" + i + "]");
                continue;
            }
            MaterialDensity.addDensity(block.func_149688_o(), density);
        }
    }

    public boolean isBlockAllowed(Block block) {
        String id = Block.field_149771_c.func_148750_c((Object)block);
        return this.useWhitelist ? this.blockWhitelist.contains(id) : !this.blockBlacklist.contains(id);
    }

    @SideOnly(value=Side.CLIENT)
    private void loadKeybindings() {
        this.kbUp = new KeyBinding("key.archimedes.up", this.getKeyIndex(this.config, "key_ascent", 13), "EsvDefcon's Skyline Mod");
        this.kbDown = new KeyBinding("key.archimedes.down", this.getKeyIndex(this.config, "key_descent", 12), "EsvDefcon's Skyline Mod");
        this.kbBrake = new KeyBinding("key.archimedes.brake", this.getKeyIndex(this.config, "key_brake", 25), "EsvDefcon's Skyline Mod");
        this.kbAlign = new KeyBinding("key.archimedes.align", this.getKeyIndex(this.config, "key_align", 14), "EsvDefcon's Skyline Mod");
        this.kbDisassemble = new KeyBinding("key.archimedes.decompile", this.getKeyIndex(this.config, "key_decompile", 52), "EsvDefcon's Skyline Mod");
        this.kbShipInv = new KeyBinding("key.archimedes.shipinv", this.getKeyIndex(this.config, "key_shipinv", 19), "EsvDefcon's Skyline Mod");
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])mc.field_71474_y.field_74324_K, (Object[])new KeyBinding[]{this.kbUp, this.kbDown, this.kbBrake, this.kbAlign, this.kbDisassemble, this.kbShipInv});
    }

    @SideOnly(value=Side.CLIENT)
    private int getKeyIndex(Configuration config, String name, int defaultkey) {
        return Keyboard.getKeyIndex((String)config.get("control", name, Keyboard.getKeyName((int)defaultkey)).getString());
    }
}

