/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.entity;

import esvdefcon.skyline.chunk.MobileChunk;
import esvdefcon.skyline.common.Skyline;
import esvdefcon.skyline.entity.EntityShip;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public abstract class ShipHandlerCommon {
    public final EntityShip ship;

    public ShipHandlerCommon(EntityShip entityship) {
        this.ship = entityship;
    }

    public boolean interact(EntityPlayer player) {
        return false;
    }

    public void onChunkUpdate() {
        MobileChunk chunk = this.ship.getShipChunk();
        this.ship.getCapabilities().clearBlockCount();
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    Block block = chunk.func_147439_a(i, j, k);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    this.ship.getCapabilities().onChunkBlockAdded(block, chunk.func_72805_g(i, j, k), i, j, k);
                }
            }
        }
        this.ship.func_70105_a(Math.max(chunk.maxX() - chunk.minX(), chunk.maxZ() - chunk.minZ()), chunk.maxY() - chunk.minY());
        World.MAX_ENTITY_RADIUS = Math.max(World.MAX_ENTITY_RADIUS, (double)(Math.max(this.ship.field_70130_N, this.ship.field_70131_O) + 2.0f));
        try {
            this.ship.fillAirBlocks(new HashSet<ChunkPosition>(), -1, -1, -1);
        }
        catch (StackOverflowError e) {
            Skyline.modLog.error("Failure during ship post-initialization", (Throwable)e);
        }
        this.ship.layeredBlockVolumeCount = new int[chunk.maxY() - chunk.minY()];
        for (int y = 0; y < this.ship.layeredBlockVolumeCount.length; ++y) {
            for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
                for (int j = chunk.minZ(); j < chunk.maxZ(); ++j) {
                    if (!chunk.isBlockTakingWaterVolume(i, y + chunk.minY(), j)) continue;
                    int n = y;
                    this.ship.layeredBlockVolumeCount[n] = this.ship.layeredBlockVolumeCount[n] + 1;
                }
            }
        }
        this.ship.isFlying = this.ship.getCapabilities().canFly();
    }
}

