/*
 * Decompiled with CFR 0.152.
 */
package esvdefcon.skyline.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import esvdefcon.skyline.blockitem.TileEntityHelm;
import esvdefcon.skyline.chunk.MobileChunkClient;
import esvdefcon.skyline.entity.EntityShip;
import esvdefcon.skyline.network.ASMessageShip;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class MsgTileEntities
extends ASMessageShip {
    private NBTTagCompound tagCompound = null;

    public MsgTileEntities() {
    }

    public MsgTileEntities(EntityShip entityship) {
        super(entityship);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf) throws IOException {
        super.encodeInto(ctx, buf);
        this.tagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntity te : this.ship.getShipChunk().chunkTileEntityMap.values()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (te instanceof TileEntityHelm) {
                ((TileEntityHelm)te).writeNBTforSending(nbt);
            } else {
                te.func_145841_b(nbt);
            }
            list.func_74742_a((NBTBase)nbt);
        }
        this.tagCompound.func_74782_a("list", (NBTBase)list);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.tagCompound, (DataOutput)out);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player) throws IOException {
        super.decodeInto(ctx, buf, player);
        if (this.ship != null) {
            DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(buf));
            try {
                this.tagCompound = CompressedStreamTools.func_74794_a((DataInputStream)in);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                in.close();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (this.ship != null && this.tagCompound != null) {
            NBTTagList list = this.tagCompound.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                if (nbt == null) continue;
                int x = nbt.func_74762_e("x");
                int y = nbt.func_74762_e("y");
                int z = nbt.func_74762_e("z");
                try {
                    TileEntity te = this.ship.getShipChunk().func_147438_o(x, y, z);
                    te.func_145839_a(nbt);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ((MobileChunkClient)this.ship.getShipChunk()).getRenderer().markDirty();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

